<?php

// Get the order ID from the URL
$purchaseid = $_GET['purchaseID'] ?? '';

// Check if the order ID is provided
if (!$purchaseid) {
    echo json_encode([
        "status" => "error",
        "message" => "Purchase ID is required."
    ]);
    exit;
}

// Define the API URL
$api_url = "https://hapitest.xyz/hapi%20bilzs%20sts/hapi%20commers/api/purchasepdfdata-api.php";

// Initialize cURL
$ch = curl_init();

// Set cURL options
curl_setopt_array($ch, [
    CURLOPT_URL => $api_url . "?purchaseID=" . urlencode($purchaseid),
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_HTTPGET => true,
]);

// Execute the request
$response = curl_exec($ch);

// Check for cURL errors
if (curl_errno($ch)) {
    echo json_encode([
        "status" => "error",
        "message" => "Failed to fetch data from API.",
        "error_detail" => curl_error($ch)
    ]);
    curl_close($ch);
    exit;
}

// Close cURL
curl_close($ch);

// Decode the JSON response
$data = json_decode($response, true);

// Check if decoding was successful and the API returned a successful response
if (!$data || $data['status'] !== 'success') {
    echo json_encode([
        "status" => "error",
        "message" => "Failed to fetch or decode API response.",
        "api_response" => $response
    ]);
    exit;
}

// Extract profile and order data
$profile = $data['profile'] ?? [];
$purchase_data = $data['purchase_data'] ?? [];
$taxvalue = $data['taxvalue'] ?? 0;
$grandtotal = $data['grandtotal'] ?? 0;
$purchasedate = $data['purchasedate'] ?? '';
$logopath = $profile['logo_path'] ?? '';
$purchaseno = $data['purchase_no']??'';
$totalSavings = $data['totalsavings']??'';
$note = $data['note'];
$terms= $data['terms'];
$qrcode =$data['qrcode'];




    // Generate HTML for the invoice


$output = '<style>

table { page-break-inside: avoid !important; }

</style>'; 



$output .= '

<!DOCTYPE html>

<html lang="en">

<head>

    <meta charset="UTF-8">

    <meta name="viewport" content="width=device-width, initial-scale=1">

    <title>Purchase Invoice</title>

    <link rel="stylesheet" type="text/css" href="pdfstyle/main-style.css">

    <script src="https://cdnjs.cloudflare.com/ajax/libs/html2pdf.js/0.9.2/html2pdf.bundle.min.js"></script>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <script>

    document.addEventListener("DOMContentLoaded", function() {

        document.getElementById("bill-download").addEventListener("click", function() {

            var element = document.getElementById("download-section");

            var opt = {

                margin: [0.5, 0.3, 0.5, 0.3],

                filename: "invoice.pdf",

                image: { type: "jpeg", quality: 0.98 },

                html2canvas: { scale: 2 },

                jsPDF: { unit: "in", format: "letter", orientation: "portrait" }

            };

            html2pdf().from(element).set(opt).save();

        });

    });

    </script>

    <style>

        body { background-color: #F9F9F9; }

        .page-break { page-break-before: always; }

        .terms .headtxt { font-size: 15px; font-weight: 600; }

        .terms p { text-align: justify; }

        .table1 tr td { padding: 5px; }

        .table1 { width: 100%; margin: 0 auto; }

        table td { font-size: 14px; }

        .table1 td { text-align: right; font-size: 14px; }

        .img-container {

            border: 1px solid lightgray;

            width: 100px;

            height: 100px;

            display: flex;

            justify-content: center;

            align-items: center;

            position: relative;

        }

        .img-container img {

            max-width: 100%;

            max-height: 100%;

            object-fit: cover; 

        }

    </style>

</head>

<body class="section-bg-one">

    <main class="container invoice-wrapper">

    <div id="download-section">

        <div class="invoice-top">

            <div class="row align-items-center">

                <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 text-center text-sm-start mb-3 mb-sm-1">

                    <a href="index.html"><img src="' . htmlspecialchars($logopath) .'" title="invoice" alt="invoice" width="130px"></a>

                </div>

                <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 text-center text-sm-end mb-3 mb-sm-1">

                    <h4 class="text-30 mb-0 mt-0">Purchase</h4>

                </div>

            </div>

            <hr>

            <div class="row">

                <div class="col-sm-6"><strong>Purchase Date:</strong> '. htmlspecialchars($purchasedate) .'</div>

                <div class="col-sm-6 text-sm-end"> <strong>Purchase No:</strong> ' . $purchaseno . '</div>

            </div>

            <hr>

        </div>

        <hr>

        <div class="invoice-details border-top mt-20 pt-20">

            <div class="row">

                <div class="col-sm-6 text-sm-end order-sm-1">

                    <strong class="text-18 mb-3 d-inline-block">Pay To:</strong>

                     <address class="mb-4">

                        <b style="">'. htmlspecialchars($profile['store_name']) . ',</b><br/>

                  
                        '. htmlspecialchars($profile['street1']) .' '. htmlspecialchars($profile['street2']) .'<br>

                        ' . htmlspecialchars($profile['City']) . ' - '. htmlspecialchars($profile['Pincode']) .'<br>

                        '. htmlspecialchars($profile['phone']) .'

                    </address>

                </div>

                <div class="col-sm-6 order-sm-0">

                    <strong class="text-18 mb-3 d-inline-block">Purchased To:</strong>
    <address class="mb-4">

                        '. htmlspecialchars($profile['displayname']).'<br>

                        '. htmlspecialchars($profile['address']).'<br>

                        '. htmlspecialchars($profile['city']).' - '. htmlspecialchars($profile['pincode']).'<br>

                        '. htmlspecialchars($profile['phoneno']).'

                    </address>

                </div>

            </div>

        </div>

        <div class="card mb-3">

            <div class="card-body p-0">

                <div class="table-responsive">

                <table class="table mb-0">

                <thead class="card-header">

                    <tr>

                        <td class="col-2"><strong>S. No</strong></td>

                        <td class="col-9"><strong>Product Name</strong></td>

                        <td class="col-4"><strong>Qty</strong></td>

                        <td class="col-3 text-center"><strong>MRP</strong></td>

                        <td class="col-3 text-center"><strong>Rate</strong></td>

                        <td class="col-3 text-end"><strong>Disc</strong></td>

                        <td class="col-3 text-end"><strong>Tax</strong></td>

                        <td class="col-3 text-end"><strong>Amount</strong></td>

                    </tr>

                </thead>

                <tbody>';
                $count = 0;
                $productsPerPage = 25;
                foreach ($purchase_data as $index => $item) {
                    $count++;
                
                    $output .= '
    <tr>
                                <td class="col-3">'.$count.'</td> 
                                <td class="col-3">'. htmlspecialchars($item['Product_name']) . '</td>  
                                <td class="col-4">'. $item['Qty'] . '</td>  
                                <td class="col-2 text-center">'. number_format($item['MRP'], 2) . '</td>  
                                <td class="col-1 text-center">' . htmlspecialchars($item['Selling_price']) . '</td>    
                                <td class="col-2 text-end">'. $item['Discount_percentage'] .'%</td>  
                                <td class="col-2 text-end">'. $item['Tax'].'</td>  
                                <td class="col-2 text-end">'. htmlspecialchars($item['Product_total']) .'</td>  
                            </tr>';
                        }
                            // Tax calculations for each product
                            $tax_percentage = $item['Tax_percentage'] ?? 0;
                            $tax_value = $item['Tax'] ?? 0;
                        
                            if ($tax_percentage > 0) {
                                $cgst = $tax_value / 2;
                                $sgst = $tax_value / 2;
                        
                                $output .= ' 
                                <tr>
                                    <td colspan="7" class="text-end"><strong>CGST @ ' . $tax_percentage / 2 . '% </strong></td>
                                    <td class="text-end">' . number_format($cgst, 2) . '</td>       
                                </tr>
                                <tr>
                                    <td colspan="7" class="text-end"><strong>SGST @ ' . $tax_percentage / 2 . '% </strong></td>
                                    <td class="text-end">' . number_format($sgst, 2) . '</td>       
                                </tr>';
                            }
                        
                            // Page break after every 25 products
                            if ($count % $productsPerPage == 0) {
                                $output .= '<tr><td colspan="8" style="page-break-before:always;"></td></tr>'; 
                            }
                        

$output .= '

<tr>

<td colspan="7" class="text-end">Total Savings:</td>  

<td class="text-end">₹'. $totalSavings . '</td>  

</tr>

<tr>

<td colspan="7" class="text-end">Grand Total:</td>  

<td class="text-end">' . $grandtotal. '</td>  

</tr>

</tbody>

</table>

  </div>

  </div>

  </div>

  <div class="invoice-footer text-center mt-20">

    <p>'.$notes.'</p>

  </div>

  <br>

  <div class="terms">

    <div class="row">

      <div class="col-md-7 text-left">

          <div class="headtxt">Terms & Conditions: </div>

          <p>'.$terms.'</p>

          <br>

      </div>

      <div class="col-md-1"></div>

      <div class="col-md-4 text-right" style="display: flex; flex-direction: column; align-items: flex-end;">

      <div class="img-container">

          <img src="'.$qrcode.'" alt=""/>

      </div>

      <br>

          <table class="table1 text-right">

              <tr>

                  <td>Account No: </td>

                  <td>'. htmlspecialchars($profile['accountno']).' </td>

              </tr>

              <tr>

                  <td>IFSC Code: </td>

                  <td>'. htmlspecialchars($profile['ifsc']).'</td>

              </tr>

              <tr>

                  <td>Bank: </td>

                  <td>'. htmlspecialchars($profile['bankname']).' </td>

              </tr>

              <tr>

                  <td>UPI ID: </td>

                  <td>'. htmlspecialchars($profile['upiid']).'</td>

              </tr>

          </table>    

    </div>

  </div>

</div>





<div class="text-center mt-5 mb-4 regular-button">

    <div class="d-print-none d-flex justify-content-center flex-wrap gap-10"> 

        <button id="bill-download" class="btn-primary-outline">Download</button> 

        <a href="javascript:window.print()" class="btn-primary-fill">Print Invoice</a> 

    </div>

</div>



</main>

</body>

</html>';

$pdfContents[] = $output;




echo implode('<div style="page-break-after: always;"></div>', $pdfContents);

?>

